/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public abstract class LOTRWorldGenMoredainHut
extends LOTRWorldGenStructureBase2 {
    protected Block clayBlock = Blocks.field_150405_ch;
    protected int clayMeta = 0;
    protected Block stainedClayBlock = Blocks.field_150406_ce;
    protected int stainedClayMeta = 1;
    protected Block brickBlock = LOTRMod.brick3;
    protected int brickMeta = 10;
    protected Block brickSlabBlock = LOTRMod.slabSingle7;
    protected int brickSlabMeta = 0;
    protected Block plankBlock = Blocks.field_150344_f;
    protected int plankMeta = 4;
    protected Block plankSlabBlock = Blocks.field_150376_bx;
    protected int plankSlabMeta = 4;
    protected Block fenceBlock = Blocks.field_150422_aJ;
    protected int fenceMeta = 4;
    protected Block thatchBlock = LOTRMod.thatch;
    protected int thatchMeta = 0;
    protected Block thatchSlabBlock = LOTRMod.slabSingleThatch;
    protected int thatchSlabMeta = 0;

    public LOTRWorldGenMoredainHut(boolean flag) {
        super(flag);
    }

    protected abstract int getOffset();

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        this.setOriginAndRotation(world, i, j, k, rotation, this.getOffset());
        if (this.restrictions) {
            int minHeight = 0;
            int maxHeight = 0;
            int range = this.getOffset();
            for (int i1 = -range; i1 <= range; ++i1) {
                for (int k1 = -range; k1 <= range; ++k1) {
                    int j1 = this.getTopBlock(world, i1, k1);
                    Block block = this.getBlock(world, i1, j1 - 1, k1);
                    if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150354_m && block != Blocks.field_150348_b) {
                        return false;
                    }
                    if (j1 < minHeight) {
                        minHeight = j1;
                    }
                    if (j1 > maxHeight) {
                        maxHeight = j1;
                    }
                    if (maxHeight - minHeight <= 5) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void layFoundation(World world, int i, int k) {
        for (int j = 0; !(j != 0 && this.isOpaque(world, i, j, k) || this.getY(j) < 0); --j) {
            this.setBlockAndMetadata(world, i, j, k, this.clayBlock, this.clayMeta);
            this.setGrassToDirt(world, i, j - 1, k);
        }
    }

    protected void dropFence(World world, int i, int j, int k) {
        while (true) {
            this.setBlockAndMetadata(world, i, j, k, this.fenceBlock, this.fenceMeta);
            if (this.isOpaque(world, i, j - 1, k)) break;
            --j;
        }
    }
}

